<?php
if (!function_exists('wp_handle_upload')) {
    require_once ABSPATH . 'wp-admin/includes/file.php';
}

// Özel alanları ekle
function custom_comment_fields() {
    ?>
<!--    <div class="uk-margin">-->
<!--        <label class="control-label" for="input-name">Your Name</label>-->
<!--        <input class="uk-input" type="text" aria-label="Input" id="comment_title" name="comment_title" />-->
<!--    </div>-->

    <div class="uk-margin">
        <label class="control-label" for="input-title">Comment Title</label>
        <input class="uk-input" type="text" aria-label="Input" id="comment_title" name="comment_title" />
    </div>

    <div class="uk-margin">
        <label class="control-label" for="input-review">Your Review</label>
        <textarea name="comment" required rows="5" id="input-review" class="uk-textarea" aria-label="Textarea"></textarea>
        <small><span class="text-danger">Note:</span> HTML is not translated!</small>
    </div>

    <div class="uk-margin uk-grid-small uk-child-width-auto uk-grid">
        <label class="control-label" for="input-rating">Rating</label>
        <div class="uk-margin-remove uk-width-1-1 uk-grid uk-grid-small uk-items-center">
            <div class="rating uk-padding-remove">
                <input type="radio" name="rating" id="r1" value="5" checked />
                <label for="r1"></label>
                <input type="radio" name="rating" id="r2" value="4" />
                <label for="r2"></label>
                <input type="radio" name="rating" id="r3" value="3" />
                <label for="r3"></label>
                <input type="radio" name="rating" id="r4" value="2" />
                <label for="r4"></label>
                <input type="radio" name="rating" id="r5" value="1" />
                <label for="r5"></label>
            </div>
        </div>
    </div>

    <div class="uk-margin">
        <div class="uk-display-block" uk-form-custom>
            <input type="file" aria-label="Custom controls" id="review_images" name="review_images[]" multiple />
            <button class="uk-button uk-button-default" type="button" tabindex="-1">Upload Images (Max: 5)</button>
        </div>
        <div id="image-preview"></div>
    </div>

    <div class="uk-text-center">
        <button type="submit" id="button-review" class="uk-button uk-button-primary">Send</button>
    </div>
    <?php
}

function custom_review_form_fields() {
    add_action('comment_form_logged_in_after', 'custom_comment_fields');
    add_action('comment_form_after_fields', 'custom_comment_fields');
}
add_action('init', 'custom_review_form_fields');


// Yorum kaydedilirken özel alanları da kaydet
function save_custom_comment_fields($comment_id) {
    if (isset($_POST['comment_title'])) {
        update_comment_meta($comment_id, 'comment_title', sanitize_text_field($_POST['comment_title']));
    }

    if (isset($_POST['rating'])) {
        update_comment_meta($comment_id, 'rating', intval($_POST['rating']));
    }

    if (!empty($_FILES['review_images']['name'][0])) {
        $files = $_FILES['review_images'];
        $uploaded_images = array();

        if (count($files['name']) > 5) {
            wp_die('En fazla 5 görsel yükleyebilirsiniz.');
        }

        foreach ($files['name'] as $key => $value) {
            if ($files['error'][$key] === 0) {
                $file = array(
                    'name'     => $files['name'][$key],
                    'type'     => $files['type'][$key],
                    'tmp_name' => $files['tmp_name'][$key],
                    'error'    => $files['error'][$key],
                    'size'     => $files['size'][$key],
                );

                $upload = wp_handle_upload($file, array('test_form' => false));

                if (!empty($upload['url'])) {
                    $uploaded_images[] = $upload['url'];
                }
            }
        }

        if (!empty($uploaded_images)) {
            update_comment_meta($comment_id, 'review_images', $uploaded_images);
        }
    }
}
add_action('comment_post', 'save_custom_comment_fields');

// Form validasyonu
function verify_custom_comment_fields($commentdata) {
    if (!isset($_POST['comment_title']) || empty($_POST['comment_title'])) {
        wp_die('Lütfen bir yorum başlığı girin.');
    }

    if (!isset($_POST['rating']) || empty($_POST['rating'])) {
        wp_die('Lütfen bir değerlendirme puanı seçin.');
    }

    return $commentdata;
}
add_filter('preprocess_comment', 'verify_custom_comment_fields');

// Yorumları görüntüleme fonksiyonu
function display_custom_review($comment) {
    $rating = get_comment_meta($comment->comment_ID, 'rating', true);
    $title = get_comment_meta($comment->comment_ID, 'comment_title', true);
    ?>
    <div class="review-item" id="comment-<?= $comment->comment_ID; ?>">
        <div class="review-title"><?php echo esc_html($title); ?></div>
        <div class="review-rating">
            <?php
            for($i = 1; $i <= 5; $i++) {
                echo $i <= $rating ? '★' : '☆';
            }
            ?>
        </div>
        <div class="review-author">
            <?php echo get_comment_author($comment); ?> -
            <?php echo get_comment_date('d.m.Y', $comment); ?>
        </div>
        <div class="review-content">
            <?php echo wpautop(get_comment_text($comment)); ?>
        </div>
    </div>
    <?php
}

// Yorum listesini özelleştir
function custom_review_list($comment, $args, $depth) {
    display_custom_review($comment);
}
add_filter('woocommerce_product_review_list_args', function($args) {
    $args['callback'] = 'custom_review_list';
    return $args;
});

function add_comment_form_enctype($args) {
    $args['format'] = 'html5'; // HTML5 form kullanımı
    return $args;
}
add_filter('comment_form_defaults', 'add_comment_form_enctype');

function add_enctype_to_comment_form() {
    echo '<script>
        document.addEventListener("DOMContentLoaded", function() {
            var form = document.getElementById("commentform");
            if (form) {
                form.setAttribute("enctype", "multipart/form-data");
            }
        });
    </script>';
}
add_action('comment_form_after', 'add_enctype_to_comment_form');



// Özel yorumları listele
function custom_woocommerce_product_review_list($comment, $args, $depth) {
    $comment_id = $comment->comment_ID;
    $rating = get_comment_meta($comment_id, 'rating', true);
    $title = get_comment_meta($comment_id, 'comment_title', true);
    $images = get_comment_meta($comment_id, 'review_images', true);
    $author = get_comment_author($comment_id);
    // İsmin ilk harfi ve soyadın ilk harfini al (örn: "Duygu Altın" -> "Duygu A.")
    $name_parts = explode(' ', $author);
    $formatted_name = $name_parts[0];
    if (isset($name_parts[1])) {
        $formatted_name .= ' ' . substr($name_parts[1], 0, 1) . '.';
    }
    ?>

    <div class="review-item" id="comment-<?= $comment->comment_ID; ?>">
        <div class="uk-grid uk-grid-small uk-items-center">
            <div class="product-stars">
                <?php
                for ($i = 1; $i <= 5; $i++) {
                    $star_class = $i <= $rating ? 'star filled' : 'star';
                    echo '<span uk-icon="icn-star-2" class="' . $star_class . '"></span>';
                }
                ?>
            </div>

            <div class="author-name"><?php echo esc_html($formatted_name); ?></div>
        </div>

        <div class="uk-grid-medium uk-items-center uk-grid" uk-grid="">
            <div class="uk-width-8-12@m uk-first-column">
                <div class="review-text">
                    <?php if ($title): ?>
                        <h3><?php echo esc_html($title); ?></h3>
                    <?php endif; ?>
                    <p><?php echo esc_html($comment->comment_content); ?></p>
                </div>
            </div>

            <?php if (!empty($images) && is_array($images)): ?>
                <div class="uk-width-4-12@m">
                    <div class="review-images">
                        <div class="uk-grid uk-flex-right@m uk-child-width-1-6@xl uk-child-width-1-5@l uk-child-width-1-4 uk-grid-xsmall uk-grid-match" uk-lightbox="">
                            <?php foreach (array_slice($images, 0, 5) as $image_url): ?>
                                <a href="<?php echo esc_url($image_url); ?>">
                                    <img src="<?php echo esc_url($image_url); ?>" alt="<?php echo esc_attr($formatted_name); ?>" />
                                </a>
                            <?php endforeach; ?>
                        </div>
                    </div>
                </div>
            <?php endif; ?>
        </div>
    </div>
    <?php
}
function custom_woocommerce_product_review_list_2($comment, $args, $depth) {
    $comment_id = $comment->comment_ID;
    $rating = get_comment_meta($comment_id, 'rating', true);
    $title = get_comment_meta($comment_id, 'comment_title', true);
    $images = get_comment_meta($comment_id, 'review_images', true);

    ?>
    <li id="comment-<?php echo $comment_id; ?>" class="review">
        <div class="comment_container">
            <div class="comment-text">
                <p class="meta">
                    <strong class="woocommerce-review__author"><?php echo get_comment_author($comment_id); ?></strong>
                    <time class="woocommerce-review__published-date" datetime="<?php echo get_comment_date('c', $comment_id); ?>"><?php echo get_comment_date('', $comment_id); ?></time>
                </p>
                <?php if ($rating): ?>
                    <div class="star-rating">
                        <span style="width:<?php echo ($rating / 5) * 100; ?>%">Rated <strong class="rating"><?php echo $rating; ?></strong> out of 5</span>
                    </div>
                <?php endif; ?>
                <?php if ($title): ?>
                    <h4 class="review-title"><?php echo esc_html($title); ?></h4>
                <?php endif; ?>
                <?php comment_text($comment_id); ?>

                <?php if (!empty($images) && is_array($images)): ?>
                    <div class="review-images">
                        <?php foreach (array_slice($images, 0, 5) as $image_url): ?>
                            <img src="<?php echo esc_url($image_url); ?>" alt="Review Image" style="max-width: 100px; max-height: 100px; margin-right: 5px;" />
                        <?php endforeach; ?>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </li>
    <?php
}

// AJAX ile daha fazla yorum yükleme
function load_more_reviews() {
    $product_id = $_POST['product_id'];
    $page = $_POST['page'];
    $comments_per_page = 3;

    $args = array(
        'post_id' => $product_id,
        'status' => 'approve',
        'orderby' => 'comment_date',
        'order' => 'DESC',
        'number' => $comments_per_page,
        'offset' => ($page - 1) * $comments_per_page,
    );

    $comments = get_comments($args);

    ob_start();
    wp_list_comments(array(
        'callback' => 'custom_woocommerce_product_review_list',
        'style' => 'ol',
        'short_ping' => true,
    ), $comments);
    $html = ob_get_clean();

    $has_more = count($comments) == $comments_per_page;

    wp_send_json(array(
        'html' => $html,
        'has_more' => $has_more,
    ));
}
add_action('wp_ajax_load_more_reviews', 'load_more_reviews');
add_action('wp_ajax_nopriv_load_more_reviews', 'load_more_reviews');


// ----------------------------------------------------------------------------------

// Todo: Admin paneline yorum başlığı kolonunu ekle
function add_comment_title_column($columns) {
    $new_columns = array();

    // Mevcut kolonları döngüye al ve yazar kolonundan sonra başlık kolonunu ekle
    foreach($columns as $key => $value) {
        $new_columns[$key] = $value;
        if($key === 'author') {
            $new_columns['comment_title'] = 'Yorum Başlığı';
        }
    }

    return $new_columns;
}
add_filter('manage_edit-comments_columns', 'add_comment_title_column');

// Kolon içeriğini göster
function show_comment_title_column_content($column, $comment_id) {
    if ($column === 'comment_title') {
        $title = get_comment_meta($comment_id, 'comment_title', true);
        echo esc_html($title ?: '---');
    }
}
add_action('manage_comments_custom_column', 'show_comment_title_column_content', 10, 2);

// Kolonu sıralanabilir yap
function make_comment_title_column_sortable($columns) {
    $columns['comment_title'] = 'comment_title';
    return $columns;
}
add_filter('manage_edit-comments_sortable_columns', 'make_comment_title_column_sortable');

// Sıralama işlemini gerçekleştir
function sort_comment_title_column($query) {
    if (!is_admin()) {
        return;
    }

    $orderby = $query->get('orderby');
    if ('comment_title' === $orderby) {
        $query->set('meta_key', 'comment_title');
        $query->set('orderby', 'meta_value');
    }
}
add_action('pre_get_comments', 'sort_comment_title_column');

// Quick Edit ve Bulk Edit'e başlık alanı ekle
function add_quick_edit_comment_title($column_name, $comment_type) {
    if ('comment_title' === $column_name && 'comment' === $comment_type) {
        ?>
        <fieldset>
            <div class="inline-edit-col">
                <label>
                    <span class="title">Yorum Başlığı</span>
                    <span class="input-text-wrap">
                        <input type="text" name="comment_title" class="comment_title" value="" />
                    </span>
                </label>
            </div>
        </fieldset>
        <?php
    }
}
add_action('quick_edit_custom_box', 'add_quick_edit_comment_title', 10, 2);

// Quick Edit verilerini kaydet
function save_quick_edit_comment_title($comment_id) {
    if (isset($_POST['comment_title'])) {
        update_comment_meta($comment_id, 'comment_title', sanitize_text_field($_POST['comment_title']));
    }
}
add_action('edit_comment', 'save_quick_edit_comment_title');

// Yorum düzenleme sayfasına başlık alanı ekle
function add_comment_meta_box() {
    add_meta_box(
        'comment_meta_box',
        __('Yorum Ayarları', 'leanfit'),
        'comment_meta_box_html',
        'comment',
        'normal',
        'high'
    );
}
add_action('add_meta_boxes_comment', 'add_comment_meta_box');

// Meta box içeriği
function comment_meta_box_html($comment) {
    $show_in_home = get_comment_meta($comment->comment_ID, 'show_in_home', true);
    wp_nonce_field('comment_meta_box_nonce', 'comment_meta_box_nonce');
    ?>
    <div class="misc-pub-section">
        <label>
            <input type="checkbox" name="show_in_home" value="1" <?php checked($show_in_home, '1'); ?>>
            <?php _e('Ana Sayfada Göster', 'leanfit'); ?>
        </label>
    </div>
    <?php
}

// Yorum meta verilerini kaydetme
function save_comment_meta_box($comment_id) {
    if (!isset($_POST['comment_meta_box_nonce']) || 
        !wp_verify_nonce($_POST['comment_meta_box_nonce'], 'comment_meta_box_nonce')) {
        return;
    }

    if (isset($_POST['show_in_home'])) {
        update_comment_meta($comment_id, 'show_in_home', '1');
    } else {
        delete_comment_meta($comment_id, 'show_in_home');
    }
}
add_action('edit_comment', 'save_comment_meta_box');

// Ana sayfada gösterilecek yorumları getirmek için fonksiyon
function get_all_reviews() {
    $args = array(
        'status' => 'approve',
        'type' => 'review'
    );

    return get_comments($args);
}

// Ana sayfada gösterilecek yorumları getirmek için fonksiyon
function get_homepage_reviews() {
    $args = array(
        'meta_key' => 'show_in_home',
        'meta_value' => '1',
        'status' => 'approve',
        'type' => 'review'
    );
    
    return get_comments($args);
}

// Yorum düzenleme sayfasına birden fazla görseli ekleyelim
function add_review_images_meta_box() {
    add_meta_box(
        'review_images_meta_box', // Meta box ID
        'Yorum Görselleri',        // Başlık
        'review_images_meta_box_content', // İçerik fonksiyonu
        'comment',                 // Yorumlar için geçerli
        'normal',                  // Konum
        'high'                     // Öncelik
    );
}
add_action('add_meta_boxes_comment', 'add_review_images_meta_box');

// Yorum düzenleme sayfasına review_images'i ve silme butonlarını ekleyelim
function review_images_meta_box_content($comment) {
    // Yorum meta verisinden görselleri alalım
    $review_images = get_comment_meta($comment->comment_ID, 'review_images', true);

    // Eğer görsel varsa, ekranda gösterelim
    if ($review_images && is_array($review_images)) {
        echo '<ul>';
        foreach ($review_images as $index => $image_url) {
            // Görseli ve silme butonunu ekleyelim
            echo '<li style="display:inline-block; margin-right:10px;">';
            echo '<a href="' . esc_url($image_url) . '" target="_blank">';
            echo '<img src="' . esc_url($image_url) . '" style="max-width: 100px; max-height: 100px; border: 1px solid #ccc;"/>';
            echo '</a>';
            echo '<br>';
            // Silme butonu
            echo '<a href="#" class="delete-review-image" data-comment-id="' . $comment->comment_ID . '" data-image-index="' . $index . '" style="color:red; text-decoration:none;">Sil</a>';
            echo '</li>';
        }
        echo '</ul>';
    } else {
        echo 'Henüz görsel eklenmemiş.';
    }
}

// Ajax ile review_images silme işlemi
function delete_review_image() {
    // Ajax'tan gelen değerleri alalım
    $comment_id = intval($_POST['comment_id']);
    $image_index = intval($_POST['image_index']);

    // Yorum meta verisini alalım
    $review_images = get_comment_meta($comment_id, 'review_images', true);

    // Eğer görseller varsa ve belirtilen indeks geçerliyse, görseli silelim
    if ($review_images && isset($review_images[$image_index])) {
        unset($review_images[$image_index]); // Görseli diziden çıkaralım
        // Silinen görselleri tekrar kaydedelim
        update_comment_meta($comment_id, 'review_images', array_values($review_images));
    }

    // Başarılı bir cevap döndürelim
    wp_send_json_success();
}
add_action('wp_ajax_delete_review_image', 'delete_review_image');


// Ajax URL'sini temaya ekleyelim
function add_ajax_url() {
    echo '<script type="text/javascript">var ajaxurl = "' . admin_url('admin-ajax.php') . '";</script>';
}
add_action('wp_footer', 'add_ajax_url');

// Admin panelinde JavaScript dosyasını ekle
function enqueue_admin_scripts() {
    // Yalnızca yorum düzenleme sayfasında çalışması için kontrol ekleyelim
    $screen = get_current_screen();
    if ('comment' === $screen->base) {
        // JS dosyasını admin paneline ekleyelim
        wp_enqueue_script(
            'delete-review-image-js', // JS dosyasının adı
            get_template_directory_uri() . '/assets/js/delete-review-image.js', // Dosya yolu (temanızdaki js klasöründe olduğunu varsayalım)
            array('jquery'), // jQuery'yi bağımlılık olarak ekleyelim
            null, // Versiyon numarasını belirtmek isteyebilirsiniz
            true // Footer'da yüklenmesini sağlayalım
        );
    }
}
add_action('admin_enqueue_scripts', 'enqueue_admin_scripts');


